#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#define int long long

using namespace std;

struct point {
    int x, y;

    point() {
        x = 0;
        y = 0;
    }

    point(int a, int b) {
        x = a;
        y = b;
    }

    bool operator!=(point a) {
        return (x != a.x || y != a.y);
    }
};

struct vec {
    int x, y;

    vec(point a, point b) {
        x = b.x - a.x;
        y = b.y - a.y;
    }

    int operator^(vec a) {
        return a.x * y - x * a.y;
    }

    int operator*(vec a) {
        return x * a.x + y * a.y;
    }
};

bool good(int x, int y) {
    if (x == 0 || y == 0) {
        return 1;
    }
    if (x < 0 && y > 0) {
        return 1;
    }
    if (x > 0 && y < 0) {
        return 1;
    }
    return 0;
}

bool check(point a, point b, point c, point d) {
    vec ab(a, b), ac(a, c), ad(a, d), cd(c, d), ca(c, a), cb(c, b);
    if ((ab ^ ac) == 0 && (ab ^ ad) == 0 && a != d && a != c && b != c && b != d) return false;
    if (good((ab ^ ac), (ab ^ ad)) && good((cd ^ ca), (cd ^ cb))) return true;
    return false;
}

struct SUS {
    vector<int> p, r;

    SUS(int n) {
        r = vector<int> (n, 1);
        p = vector<int> (n);
        for (int i = 0; i < n; i++) {
            p[i] = i;
        }
    }

    int get(int x) {
        if (p[x] != x) {
            p[x] = get(p[x]);
        }
        return p[x];
    }

    int merge(int a, int b) {
        a = get(a);
        b = get(b);
        if (a == b) {
            return 1;
        }
        if (r[a] == r[b]) {
            r[a]++;
        }
        if (r[a] > r[b]) {
            p[b] = a;
        } else {
            p[a] = b;
        }
        return 0;
    }
};

void solve() {
    int n;
    cin >> n;
    vector<pair<point, point>> a(n);
    vector<pair<int, int>> g;
    for (int i = 0; i < n; i++) {
        int x1, y1, x2, y2;
        cin >> x1 >> y1 >> x2 >> y2;
        a[i] = {point(x1, y1), point(x2, y2)};
    }
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (check(a[i].first, a[i].second, a[j].first, a[j].second)) {
                g.push_back({i, j});
            }
        }
    }
    SUS sus(n);
    int ans = 1;
    for (int i = 0; i < g.size(); i++) {
        ans += sus.merge(g[i].first, g[i].second);
    }
    cout << ans << "\n";
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int t = 1;
    cin >> t;
    while (t-->0) {
        solve();
    }
    return 0;
}
